%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: apply_par_corr
%
% Scope:    apply parameter correction to delta-values
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           parameter corr index (double),
%           list of gas names (cell),
%           list of gas type "flags" (i.e., MPV positions) (double),
%           anchor dataset name (string),
%           index plot requested (double)
%
% Output:   corrected "bindata" and "binref" structures,
%           overview figures (if requested)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ref, binref, fitcoeff, bindata] = apply_par_corr(data, bindata, binref, par_idx, gasnames, gastypeflag, par_corr_anchor, plot_requested)

tic;fprintf('Running function apply_par_corr...\n');
 
if par_idx==1   %p_Cell correction
    bindata_idx=7;
end

if par_idx==2   %T_Cell correction
    bindata_idx=8;
end

if par_idx==3   %T_Chiller correction
    bindata_idx=9;
end

if par_idx==4   %T_P9 correction
    bindata_idx=10;
end

target_idx=4:6;   %d15N, d15Na, d15Nb index

% calculate fit coefficients
fitcoeff = calc_fit_coeff(bindata,gasnames,par_corr_anchor);

%get fit coefficients for d15N, d15Na, d15Nb against parameter to correct
slope = fitcoeff.slope(target_idx,bindata_idx);
intercept = fitcoeff.intercept(target_idx,bindata_idx);

ind_anchor=find(ismember(gasnames, par_corr_anchor));

%% plot data before correction

if plot_requested    
    plot_par_corr(data,bindata,binref,gasnames,bindata_idx,target_idx,slope,intercept,ind_anchor,'Before parameter correction');
end

%% apply correction (slope from anchor)

for j=1:width(target_idx)    
    for i=1:width(gastypeflag)
           bindata.(gasnames{1,i})(:,target_idx(1,j))=bindata.(gasnames{1,i})(:,target_idx(1,j))-slope(j,1)*(bindata.(gasnames{1,i})(:,bindata_idx)-binref.(gasnames{1,ind_anchor})(1,bindata_idx));
    end
    bindata.all(:,target_idx(1,j))=bindata.all(:,target_idx(1,j))-slope(j,1)*(bindata.all(:,bindata_idx)-binref.(gasnames{1,ind_anchor})(1,bindata_idx));
end

%% recalculate ref conditions

[ref, binref, bindata] = calc_ref_conditions(data,bindata,gasnames,gastypeflag);
fitcoeff = calc_fit_coeff(bindata,gasnames,par_corr_anchor);

%% get new fit coefficients after correction

slope = fitcoeff.slope(target_idx,bindata_idx);
intercept = fitcoeff.intercept(target_idx,bindata_idx);

%% plot data after correction

if plot_requested    
    plot_par_corr(data,bindata,binref,gasnames,bindata_idx,target_idx,slope,intercept,ind_anchor,'After parameter correction');
end

%%
time_elapsed=toc; fprintf('apply_par_corr completed (execution time: %1.2f s)\n',time_elapsed); 

end

